import styled from "@emotion/styled";
import { css } from "@emotion/react";

export { default as Tooltip } from "./Tooltip";
export { default as UnitPicker } from "./UnitPicker";
export { default as Popover } from "./Popover";
export { default as PopoverButton } from "./PopoverButton";
export { default as ControlTitle } from "./ControlTitle";
export { default as Tab } from "./Tab";
export { default as BlockEditor } from "./BlockEditor";
export { default as FontIconPicker } from "./FontIconPicker";

const BlockEditorWrap = styled.div`
    &::after{
        content: none !important;
    }
    .block-editor-writing-flow {
        color: var(--wp--preset--color--contrast);
        font-family: var(--wp--preset--font-family--body);
        font-size: var(--wp--preset--font-size--medium);
        font-style: normal;
        font-weight: 400;
        line-height: 1.55;
        .is-root-container{
            display: block;
            .block-editor-rich-text__editable{
                font-size: 16px;
                max-width: 100%;
            }
            .block-editor-rich-text__editable{
                margin: 25px 0 !important;
            }
            h1{
                font-size: 40px !important;
                line-height: 1.15;
            }
            h2{
                font-size: 32px !important;
                padding: 0 !important;
            }
            h3{
                font-size: 26px !important;
            }
            h4{
                font-size: 22px !important;
            }
            h5{
                font-size: 20px !important;
            }
            h6{
                font-size: 18px !important;
            }
            h1, h2, h3, h4, h5, h6{
                font-weight: 400;
                line-height: 1.2;
            }
        }
    }
`

const globalStyle = css`
    body{
        --cw__border-color: #D8E6FC;
    }
    .tippy-box{
        &[data-theme="light"]{
            background-color: #fff;
            border: 1px solid #D8E6FC;
            box-shadow: 0px 4px 6px -2px #10182808;
            box-shadow: 0px 12px 16px -4px #10182814;
            border-radius: 8px;
            .tippy-arrow{
                color: #ffffff;
            }
        }
    }
    .icon-picker-popup{
        *{
            box-sizing: border-box;
        }
        .tippy-arrow{
            display: none;
        }
        .tippy-content{
            padding: 12px 18px;
        }
        .icon-picker-icon-list{
            margin-right: -18px;
        }
        input[type="search"]{
            padding: 8px 14px;
            margin: 0 0 12px;
            border-radius: 50px;
            border: 1px solid #D8E6FC;
            font-size: 16px;
            line-height: 1.5;
            width: 100%;
            padding-left: 42px;
            background-image: url("data:image/svg+xml,%3Csvg width='20' height='20' viewBox='0 0 20 20' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M17.5 17.5L14.5834 14.5833M16.6667 9.58333C16.6667 13.4954 13.4954 16.6667 9.58333 16.6667C5.67132 16.6667 2.5 13.4954 2.5 9.58333C2.5 5.67132 5.67132 2.5 9.58333 2.5C13.4954 2.5 16.6667 5.67132 16.6667 9.58333Z' stroke='%23566267' strokeWidth='1.66667' strokeLinecap='round' strokeLinejoin='round'/%3E%3C/svg%3E%0A");
            background-repeat: no-repeat;
            background-position: 14px center;
            background-size: 20px;
        }
    }
    .cw__control-item{
        padding: 0 !important;
        justify-content: flex-start !important;;
        column-gap: 40px !important;
        &:not(:last-child){
            margin-bottom: 24px;
        }
        > header{
            flex: 0 0 30% !important;
            max-width: 220px;
            max-height: 45px;
        }
    }
	.input-selected-icon{
		border: 1px solid #EDEEEE;
		background-color: #fff;
		padding: 8px 14px;
		font-size: 16px;
		line-height: 1.7;
		width: 100%;
		max-width: 100%;
		border-radius: 4px;
		margin: 0;
		&:focus{
			outline: 1px solid #2db68d;
			box-shadow: none;
		}
		&::placeholder{
			color: rgba(0, 0, 0, 0.4);
		}
	}
`

export { BlockEditorWrap, globalStyle };
