import Isotope from "isotope-layout";
import "../sass/equipments.scss";

(() => {
	const equipments = document.querySelectorAll('.wpd-filter-item');
	let iso;

	document.addEventListener('DOMContentLoaded', function () {
		setTimeout(() => {
			const filtersElem = document.querySelector('.wpd-filters-button-group');
			iso = new Isotope(".wpd-filter-grid", {
				itemSelector: ".wpd-filter-item",
				layoutMode: "fitRows",
				getSortData: {
					name: '.wpd-equipment-title',
					originalOrder: (itemElem) => parseInt(itemElem.getAttribute('data-use-count')) || 0,
					postID: (itemElem) => parseInt(itemElem.getAttribute('data-id')) || 0,
				},
				animationOptions: {
					duration: 750,
					easing: 'linear',
					queue: false
				}
			});

			if (filtersElem) {
				// bind filter button click
				filtersElem.addEventListener('click', function (event) {
					// only work with buttons
					if (event.target.tagName !== 'BUTTON') {
						return;
					}

					var filterValue = event.target.getAttribute('data-filter');
					filterValue = filterFns[filterValue] || filterValue;
					iso.arrange({ filter: filterValue });
					buttonActive(filtersElem, event);
				});

				// layout view
				const layoutView = document.querySelector('.wpd-equipment-layout-view');
				const gridContainer = document.querySelector('.wpd-filter-grid');
				layoutView.addEventListener('click', function (event) {
					if (event.target.tagName !== 'BUTTON') {
						return;
					}
					const layoutValue = event.target.getAttribute('data-layout');
					gridContainer.setAttribute('data-layout', layoutValue);
					iso.arrange();
					buttonActive(layoutView, event);
				});
			}
		}, 1000);
	})

	// search form open
	const searchButton = document.getElementById('wpd-equipment-search-btn');
	if (searchButton) {
		const searchWrap = searchButton.closest('.wpd-equipment-search');
		const searchInput = searchWrap.querySelector('.wpd-equipment-search-input');
		const filtersGroup = document.querySelector('.wpd-filters-button-group');
		const filterActive = filtersGroup.querySelector('.is-active').getAttribute('data-filter');

		searchButton.addEventListener('click', function () {
			searchWrap.classList.toggle('is-search-open');
			setTimeout(() => {
				searchInput.focus();
			}, 100);
			clearTimeout();
		});

		document.addEventListener('click', function (event) {
			if (!searchWrap.contains(event.target)) {
				searchWrap.classList.remove('is-search-open');
				searchInput.value = '';
				document.querySelector('.wpd-equipment-no-results').style.display = 'none';
			}
		});

		searchInput.addEventListener('input', function () {
			const searchValue = searchInput.value.toLowerCase();
			let itemsFound = 0;
			equipments.forEach(function (item) {
				const title = item.querySelector('.wpd-equipment-title').textContent.toLowerCase();
				const isTitleMatch = title.includes(searchValue);
				const isFilterMatch = filterActive === '*' || item.classList.contains(filterActive.replace('.', ''));
				if (searchValue === '' || (isTitleMatch && isFilterMatch)) {
					item.style.display = 'block';
					itemsFound++;
				} else {
					item.style.display = 'none';
				}
			});
			iso.arrange();
			document.querySelector('.wpd-equipment-no-results').style.display = itemsFound === 0 ? 'block' : 'none';
		});
	}

	// button active function
	const buttonActive = (parent, event) => {
		parent.querySelector('.is-active').classList.remove('is-active');
		event.target.classList.add('is-active');
	}

	// filter functions
	var filterFns = {
		// show if number is greater than 50
		numberGreaterThan50: function (itemElem) {
			var number = itemElem.querySelector('.number').textContent;
			return parseInt(number, 10) > 50;
		},
		// show if name ends with -ium
		ium: function (itemElem) {
			var name = itemElem.querySelector('.name').textContent;
			return name.match(/ium$/);
		}
	};

	// sort data
	const sortButton = document.querySelector('.wpd-equipment-sort');
	if (sortButton) {
		const sortSelect = sortButton.querySelector('.wpd-sort');
		sortSelect.addEventListener('change', function () {
			const sortValue = sortSelect.value;
			let sortOptions = {};
			if (sortValue === 'asc') {
				sortOptions = { sortBy: 'name', sortAscending: true };
			} else if (sortValue === 'desc') {
				sortOptions = { sortBy: 'name', sortAscending: false };
			} else if (sortValue === 'most-used') {
				sortOptions = { sortBy: 'originalOrder', sortAscending: false };
			} else if (sortValue === 'latest') {
				sortOptions = { sortBy: 'postID', sortAscending: false };
			} else if (sortValue === 'oldest') {
				sortOptions = { sortBy: 'postID', sortAscending: true };
			}
			iso.arrange(sortOptions);
		});
	}

})();