import NoSleep from "nosleep.js";
import { __ } from "@wordpress/i18n";

document.addEventListener("DOMContentLoaded", () => {
    let noSleep = new NoSleep();
	let cookModeBtn = document.getElementById("cook-mode");
	if (cookModeBtn) {
		let cookModeNotification = document.querySelector(".cook-mode-notification");
		let strongText = cookModeNotification.querySelector("strong");
		function activeNotification() {
			cookModeNotification.classList.add("show");
			setTimeout(() => {
				cookModeNotification.classList.remove("show");
			}, 5000)
		}
		cookModeBtn.addEventListener("click", function () {
			if (this.checked) {
				noSleep.enable()
				activeNotification();
				strongText.innerText = __("Enabled", 'delicious-recipes-pro');
				cookModeNotification.style.backgroundColor = "#22bb33"
			} else {
				noSleep.disable()
				activeNotification();
				strongText.innerText = __("Disabled", 'delicious-recipes-pro');
				cookModeNotification.style.backgroundColor = "#bb2124"
			}
		})
	}
});