import Splide from "@splidejs/splide";

document.addEventListener("DOMContentLoaded", () => {
    // Splide slider for frontend recipe equipment
	function recipeEquipment(element = null) {
		const splides = element ? element.querySelectorAll('.dr-equipment-slider-wrapper') : document.querySelectorAll('.dr-equipment-slider-wrapper');
		const splidesCount = splides[0]?.querySelectorAll('.splide__slide').length;
		let options = {
			gap: '30px',
			pagination: false,
			perPage: 3,
			arrows: splidesCount > 3,
			type: splidesCount > 3 ? 'loop' : 'slide',
			breakpoints: {
				1024: {
                    perPage: 2,
                    arrows: splidesCount > 2,
                    type: splidesCount > 2 ? 'loop' : 'slide', // Conditional loop
                },
                640: {
                    perPage: 1,
                    arrows: splidesCount > 1,
                    type: splidesCount > 1 ? 'loop' : 'slide', // Conditional loop
                }
			},
		};

		splides.forEach(splide => {
			new Splide(splide, options).mount();
		});
	}

    recipeEquipment();
});

