<?php
/**
 * Recipe Submission Backend.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Ingredient Links page to display recipe submission toggles.
 */
class Delicious_Recipes_Recipe_Submission {

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_recipe_submission_menu' ), 25 );
	}

	/**
	 * Add page for recipe submission but hide it from menu.
	 */
	public function add_recipe_submission_menu() {
		add_submenu_page(
			'',
			__( 'Recipe Submission', 'delicious-recipes-pro' ),
			__( 'Recipe Submission', 'delicious-recipes-pro' ),
			'manage_options',
			'delicious_recipes_recipe_submission',
			array( $this, 'display_recipe_submission_menu_page' ),
			25
		);
	}

	/**
	 * Callback page.
	 *
	 * @return void
	 */
	public function display_recipe_submission_menu_page() {
		echo '<div id="dr_recipe_submission_menu_screen_page" data-rest-nonce="' . wp_create_nonce( 'wp_recipe_submission_admin' ) . '"></div>';
	}
}

new Delicious_Recipes_Recipe_Submission();
