<?php

/**
 * Template part for rating without comment.
 *
 * Use action hook: delicious_recipes_after_notes
 *
 * @package Delicious_Recipes_Pro
 */

/**
 * Exit if accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $recipe;
$global_settings = delicious_recipes_get_global_settings();
$ratings_lbl     = isset( $global_settings['ratingLabel'] ) && '' !== $global_settings['ratingLabel'] ? $global_settings['ratingLabel'] : __( 'Rate this recipe', 'delicious-recipes-pro' );
$enable_comments = isset( $global_settings['enableComments'] ) && 'yes' === $global_settings['enableComments'][0] ? true : false;
$enable_ratings  = isset( $global_settings['enableRatings']['0'] ) && 'yes' === $global_settings['enableRatings']['0'] ? true : false;

?>
<?php if ( $enable_comments && $enable_ratings && comments_open( $recipe->ID ) ) : ?>
<div id="rating-without-comment" class="rating-without-comment" data-post-id="<?php the_ID(); ?>" data-nonce="<?php echo esc_attr( wp_create_nonce( 'delicious-recipes-rating-without-review' ) ); ?>" data-label="<?php echo esc_attr( $ratings_lbl ); ?>">
	<span class="rating-without-comment-label"><?php echo esc_html( $ratings_lbl ); ?></span>
	<div id="rating-without-comment-container" class="wpd-rating-container" data-read-only="false"></div>
</div>
	<?php
endif;