<?php
/**
 * Recipe Cook Mode template.
 *
 * @since 1.2.1
 * @package Delicious_Recipes_Pro
 */

/**
 * Cookmode.
 *
 * @return void
 */
function cookmode() {
	$cook_mode_tooltip = __( 'This will prevent your screen from sleeping.', 'delicious-recipes-pro' );
	?>
	<div class="wpdelicious-cook-mode-wrapper mt-0 mb-0 ml-auto" data-tooltip="<?php echo esc_attr( $cook_mode_tooltip ); ?>">
		<input type="checkbox" name="cook-mode" id="cook-mode">
		<label for="cook-mode">
			<?php echo esc_html__( 'Cook Mode', 'delicious-recipes-pro' ); ?>
			<span class="switch"></span>
		</label>
		<span class="cook-mode-notification">
			<?php echo esc_html__( 'Cooking Mode', 'delicious-recipes-pro' ); ?>
			<strong><?php echo esc_html__( 'Disabled', 'delicious-recipes-pro' ); ?></strong>
		</span>
	</div>
	<?php
}
